import type { GridColumnsRenderContext } from "../../../models/params/gridScrollParams.js";
import { GridStateCommunity } from "../../../models/gridStateCommunity.js";
/**
 * Get the columns state
 * @category Virtualization
 */
export declare const gridVirtualizationSelector: import("@mui/x-data-grid").OutputSelector<GridStateCommunity, unknown, import("@mui/x-data-grid").GridVirtualizationState>;
/**
 * Get the enabled state for virtualization
 * @category Virtualization
 * @deprecated Use `gridVirtualizationColumnEnabledSelector` and `gridVirtualizationRowEnabledSelector`
 */
export declare const gridVirtualizationEnabledSelector: (args_0: import("react").RefObject<{
  state: GridStateCommunity;
} | null>) => boolean;
/**
 * Get the enabled state for column virtualization
 * @category Virtualization
 */
export declare const gridVirtualizationColumnEnabledSelector: (args_0: import("react").RefObject<{
  state: GridStateCommunity;
} | null>) => boolean;
/**
 * Get the enabled state for row virtualization
 * @category Virtualization
 */
export declare const gridVirtualizationRowEnabledSelector: (args_0: import("react").RefObject<{
  state: GridStateCommunity;
} | null>) => boolean;
/**
 * Get the render context
 * @category Virtualization
 * @ignore - do not document.
 */
export declare const gridRenderContextSelector: (args_0: import("react").RefObject<{
  state: GridStateCommunity;
} | null>) => import("@mui/x-data-grid").GridRenderContext;
/**
 * Get the render context, with only columns filled in.
 * This is cached, so it can be used to only re-render when the column interval changes.
 * @category Virtualization
 * @ignore - do not document.
 */
export declare const gridRenderContextColumnsSelector: (args_0: import("react").RefObject<{
  state: GridStateCommunity;
} | null>) => GridColumnsRenderContext;